/*
 * Decompiled with CFR 0.152.
 */
package com.nyfaria.numismaticoverhaul.villagers.json.adapters;

import com.google.gson.JsonObject;
import com.nyfaria.numismaticoverhaul.currency.CurrencyHelper;
import com.nyfaria.numismaticoverhaul.villagers.json.TradeJsonAdapter;
import com.nyfaria.numismaticoverhaul.villagers.json.VillagerJsonHelper;
import com.nyfaria.numismaticoverhaul.villagers.json.adapters.NumOTrade;
import java.util.Map;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.NotNull;

public class EnchantItemAdapter
extends TradeJsonAdapter {
    @Override
    @NotNull
    public VillagerTrades.ItemListing deserialize(JsonObject json) {
        this.loadDefaultStats(json, false);
        VillagerJsonHelper.assertInt(json, "level");
        boolean allow_treasure = VillagerJsonHelper.boolean_getOrDefault(json, "allow_treasure", false);
        int level = json.get("level").getAsInt();
        ItemStack item = VillagerJsonHelper.ItemStack_getOrDefault(json, "item", new ItemStack((ItemLike)Items.f_42517_));
        int base_price = GsonHelper.m_13824_((JsonObject)json, (String)"base_price", (int)200);
        return new Factory(item, this.max_uses, this.villager_experience, level, allow_treasure, this.price_multiplier, base_price);
    }

    private static class Factory
    implements VillagerTrades.ItemListing,
    NumOTrade {
        private final int experience;
        private final int maxUses;
        private final int level;
        private final boolean allowTreasure;
        private final ItemStack toEnchant;
        private final float multiplier;
        private final int basePrice;

        public Factory(ItemStack item, int maxUses, int experience, int level, boolean allowTreasure, float multiplier, int basePrice) {
            this.experience = experience;
            this.maxUses = maxUses;
            this.level = level;
            this.allowTreasure = allowTreasure;
            this.toEnchant = item;
            this.multiplier = multiplier;
            this.basePrice = basePrice;
        }

        public MerchantOffer m_213663_(Entity entity, RandomSource random) {
            ItemStack itemStack = this.toEnchant.m_41777_();
            itemStack = EnchantmentHelper.m_220292_((RandomSource)random, (ItemStack)itemStack, (int)this.level, (boolean)this.allowTreasure);
            int price = this.basePrice;
            for (Map.Entry entry : EnchantmentHelper.m_44831_((ItemStack)itemStack).entrySet()) {
                price = (int)((float)price + ((float)price * 0.1f + (float)this.basePrice * (((Enchantment)entry.getKey()).m_6591_() ? 2.0f : 1.0f) * (float)((Integer)entry.getValue()).intValue() * Mth.m_216267_((RandomSource)random, (float)0.8f, (float)1.2f) * (5.0f / (float)((Enchantment)entry.getKey()).m_44699_().m_44716_())));
            }
            return new MerchantOffer(CurrencyHelper.getClosest(price), this.toEnchant, itemStack, this.maxUses, this.experience, this.multiplier);
        }
    }
}

